﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System.Web;
using System.Web.Http;
using System.Web.OData;
using System.Web.OData.Routing;
using Microsoft.Xrm.Sdk;
using PpmsDataService.V1.Mappers;
using PpmsDataService.Models;
using PpmsDataService.VA.PPMS.Context;
using VA.PPMS.Context;
using System.Net;
using System.Net.Http;
using System.Web.Http.Description;
using Microsoft.Web.Http;

namespace PpmsDataService.V1.Controllers
{
    [EnableQuery]
    //[Authorize]
    [ApiVersion("1.0")]
    public class CareSitesController : ODataController
    {
        [ODataRoute("CareSites('{key}')")]
        public async Task<HttpResponseMessage> Get([FromODataUri] string name)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;


            //This Scenario find's the first care Site matching on the name.  
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the care Site Record
                var ppmsCareSite = context.ppms_caresiteSet.FirstOrDefault(i => i.ppms_name.Contains(name));
                if (ppmsCareSite != null)
                {
                    var ppmsCareSitesList = new List<ppms_caresite> { ppmsCareSite };
                    var careSites = await CareSiteMap.MapCareSites(ppmsCareSitesList, queryType, context);
                    return Request.CreateResponse(careSites);

                }
            }
            var message = string.Format("Care Site with Name: {0} not found", name);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("CareSites('{key}')/OwningOrganization")]
        public async Task<HttpResponseMessage> GetOwningOrganization([FromODataUri] string key)
        {

            //This Scenario find's the first care Site matching on the name.  
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsCareSite = context.ppms_caresiteSet.FirstOrDefault(i => i.ppms_name.Contains(key));
                if (ppmsCareSite != null)
                {
                    //Retrieve the related Owning Organization
                    var ppmsOwningOrg =
                        context.AccountSet.FirstOrDefault(i => i.Id == ppmsCareSite.ppms_organization.Id);
                    var ppmsOwningOrgList = new List<Account> { ppmsOwningOrg };
                    var owningOrganization =
                        await ProviderMap.MapProviders(ppmsOwningOrgList, "None", context);
                    return Request.CreateResponse(owningOrganization);
                }
            }
            var message = string.Format("Owning Organizatino with Care Site Name: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("CareSites('{key}')/Providers")]
        public async Task<HttpResponseMessage> GetProviders([FromODataUri] string key)
        {

            //This Scenario find's the first care Site matching on the name.  
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsCareSite = context.ppms_caresiteSet.FirstOrDefault(i => i.ppms_name.Contains(key));
                if (ppmsCareSite != null)
                {
                    //Retrieve the related Providers
                    var ppmsProviders =
                        context.AccountSet.Where(i => i.ppms_ownedcaresite.Id == ppmsCareSite.Id);
                    var ppmsProvidersList = ppmsProviders.ToList();
                    var providers =
                        await ProviderMap.MapProviders(ppmsProvidersList, "None", context);
                    return Request.CreateResponse(providers);

                }
            }
            var message = string.Format("Providers with Care Site Name: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("CareSites('{key}')/ProviderServices")]
        public async Task<HttpResponseMessage> GetRelatedProviderServices([FromODataUri] string key)
        {

            //This Scenario find's the first care Site matching on the name.  
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsCareSite = context.ppms_caresiteSet.FirstOrDefault(i => i.ppms_name.Contains(key));
                if (ppmsCareSite != null)
                {
                    //Retrieve the related Provider Services
                    var ppmsProviderServices =
                        context.ppms_providerserviceSet.Where(i => i.ppms_caresite.Id == ppmsCareSite.Id);
                    var ppmsProviderServicesList = ppmsProviderServices.ToList();
                    var providerServices =
                        await ProviderServicesMap.MapProviderServices(ppmsProviderServicesList, "None", context);
                    return Request.CreateResponse(providerServices);
                }
            }
            var message = string.Format("Provider Services with Care Site Name: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("CareSites('{key}')/ProviderPrivileges")]
        public async Task<HttpResponseMessage> GetProviderPrivileges([FromODataUri] string key)
        {

            //This Scenario find's the first care Site matching on the name.  
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsCareSite = context.ppms_caresiteSet.FirstOrDefault(i => i.ppms_name.Contains(key));
                if (ppmsCareSite != null)
                {
                    //Retrieve the related Provider Privileges 
                    var ppmsProviderPrivileges =
                        context.ppms_providerprivilegeSet.Where(i => i.ppms_CareSite.Id == ppmsCareSite.Id);
                    var ppmsProviderPrivilegesList = ppmsProviderPrivileges.ToList();
                    var providerPrivileges =
                        await ProviderPrivilegesMap.MapProviderPrivileges(ppmsProviderPrivilegesList, "None", context);
                    return Request.CreateResponse(providerPrivileges);
                }
            }
            var message = string.Format("Provider Privileges with Care Site Name: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("CareSites('{key}')/VaProviderRelationships")]
        public async Task<HttpResponseMessage> GetCareSiteVaProviderRelationships([FromODataUri] string key)
        {

            //This Scenario find's the first care Site matching on the name.  
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsCareSite = context.ppms_caresiteSet.FirstOrDefault(i => i.ppms_name.Contains(key));
                if (ppmsCareSite != null)
                {
                    var ppmsVaProviderRelationships = context.ppms_vaproviderrelationshipSet.Where(i => i.ppms_CareSiteId.Id == ppmsCareSite.Id);
                    var ppmsVaProviderRelationshipsList = ppmsVaProviderRelationships.ToList();
                    if (ppmsVaProviderRelationshipsList.Any())
                    {
                        //Map Va Provider Relationships
                        var vaProviderRelationships = await VaProviderRelationshipMap.MapVaProviderRelationships(ppmsVaProviderRelationshipsList, "None", context);
                        return Request.CreateResponse(vaProviderRelationships);
                    }
                }
            }
            var message = string.Format("Provider Privileges with Care Site Name: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("CareSites('{key}')/SiteContact")]
        public async Task<HttpResponseMessage> GetSiteContact([FromODataUri] string key)
        {

            //This Scenario find's the first care Site matching on the name.  
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsCareSite = context.ppms_caresiteSet.FirstOrDefault(i => i.ppms_name.Contains(key));
                if (ppmsCareSite != null)
                {
                    //Retrieve the related Site Contact
                    var ppmsSiteContact =
                        context.ContactSet.FirstOrDefault(i => i.Id == ppmsCareSite.ppms_SiteContact.Id);
                    var ppmsSiteContactList = new List<Contact> { ppmsSiteContact };
                    var siteContact =
                        await ProviderContactsMap.MapProviderContacts(ppmsSiteContactList, "None", context);
                    return Request.CreateResponse(siteContact);
                }
            }
            var message = string.Format("Site Contact with Care Site Name: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [HttpGet]
        [MapToApiVersion("1.0")]
        [ResponseType(typeof(CareSite))]
        [ODataRoute("GetCareSiteByCity")]
        public async Task<HttpResponseMessage> GetCareSiteByCity([FromODataUri] string city)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {

                var ppmsCareSites = context.ppms_caresiteSet.Where(i => i.ppms_address_city.Contains(city));
                var ppmsCareSitesList = ppmsCareSites.ToList();
                if (ppmsCareSitesList.Any())
                {
                    //Map Care Sites
                    var careSites = await CareSiteMap.MapCareSites(ppmsCareSitesList, "None", context);
                    return Request.CreateResponse(careSites);
                }
                var message = string.Format("Care Sites with City Name: {0} not found", city);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
            }
        }

        [HttpGet]
        [MapToApiVersion("1.0")]
        [ResponseType(typeof(CareSite))]
        [ODataRoute("GetCareSiteByState")]
        public async Task<HttpResponseMessage> GetCareSiteByState([FromODataUri] string state)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {

                var ppmsCareSites = context.ppms_caresiteSet.Where(i => i.ppms_statename.Contains(state));
                var ppmsCareSitesList = ppmsCareSites.ToList();
                if (ppmsCareSitesList.Any())
                {
                    //Map Care Sites
                    var careSites = await CareSiteMap.MapCareSites(ppmsCareSitesList, "None", context);
                    return Request.CreateResponse(careSites);
                }
                var message = string.Format("Care Sites with State Name: {0} not found", state);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
            }
        }

        [HttpGet]
        [MapToApiVersion("1.0")]
        [ResponseType(typeof(CareSite))]
        [ODataRoute("GetCareSiteByZip")]
        public async Task<HttpResponseMessage> GetCareSiteByZip([FromODataUri] string zip)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsCareSites = context.ppms_caresiteSet.Where(i => i.ppms_address_postalcode.Contains(zip));
                var ppmsCareSitesList = ppmsCareSites.ToList();
                if (ppmsCareSitesList.Any())
                {
                    //Map Care Sites
                    var careSites = await CareSiteMap.MapCareSites(ppmsCareSitesList, "None", context);
                    return Request.CreateResponse(careSites);
                }
                var message = string.Format("Care Sites with Zip Code: {0} not found", zip);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
            }
        }

        /*
        [ODataRoute("CareSites(City={city},State={state})")]
        public async Task<IHttpActionResult> GetCareSiteCityState([FromODataUri] string city, [FromODataUri]string state)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsCareSites = context.ppms_caresiteSet.Where(i => i.ppms_address_city.Contains(city));
                var ppmsCareSitesList = ppmsCareSites.ToList();
                if (ppmsCareSitesList.Any())
                {
                    //Map Care Sites
                    var careSites = await CareSiteMap.MapCareSites(ppmsCareSitesList, "None", context);
                    return Request.CreateResponse(careSites);
                }
                var message = string.Format("Agreement Provider with Name: {0} not found", key);
            }
        }
        */

        [ODataRoute("CareSites")]
        public async Task<HttpResponseMessage> Get()
        {
            //This Scenario returns the first 50 Providers in the system. . 
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsCareSites = context.ppms_caresiteSet.Where(i => i.ppms_name != null).Take(50);
                var ppmsCareSitesList = ppmsCareSites.ToList();
                if (ppmsCareSitesList.Any())
                {
                    //Map Care Sites
                    var careSites = await CareSiteMap.MapCareSites(ppmsCareSitesList, "None", context);
                    return Request.CreateResponse(careSites);
                }
                var message = string.Format("Care Sites not found");
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }
    }
}